﻿using Microsoft.AspNetCore.Http;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.Helpers
{
    internal static class DasHelper
    {
        public static DasMessage ParseHeaders(HttpRequest request)
        {
            if (request != null)
            {
                return new DasMessage(
                    request.Headers["X-ConversationID"],
                    request.Headers["X-RoutingSenderID"],
                    request.Headers["X-RoutingReceiverIDs"],
                    request.Headers["X-TransactionID"]
                );
            }

            return new DasMessage();
        }
    }
}